package net.eusashead.parquet.http.response;

import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.EntityConverter;
import net.eusashead.parquet.entity.Link;
import net.eusashead.parquet.entity.PropertyConverter;
import net.eusashead.parquet.http.HttpStatus;

public interface DeleteResponseBuilder extends ResponseBuilder {
	
	@Override
	DeleteResponseBuilder status(HttpStatus status);
	
	@Override
	DeleteResponseBuilder property(String name, Object value);
	
	@Override
	DeleteResponseBuilder property(String name, Object value, PropertyConverter<?,Object> converter);
	
	@Override
	DeleteResponseBuilder embed(String rel, Entity entity);
	
	@Override
	<T> DeleteResponseBuilder embed(String rel, T target, EntityConverter<T> converter);
	
	@Override
	<T> DeleteResponseBuilder forEach(String rel, Iterable<T> target, EntityConverter<T> converter);
	
	@Override
	DeleteResponseBuilder link(Link link);
	
	@Override
	DeleteResponseBuilder body(Entity entity);
	
}
