package net.eusashead.parquet.http.request.impl;

import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.hash.HashStrategy;
import net.eusashead.parquet.http.conneg.MediaTypeStrategy;
import net.eusashead.parquet.http.request.PatchRequest;
import net.eusashead.parquet.http.response.PatchResponseBuilder;
import net.eusashead.parquet.http.response.impl.PatchResponseBuilderImpl;
import net.eusashead.parquet.http.serializer.Deserializer;
import net.eusashead.parquet.http.serializer.Serializer;

import org.vertx.java.core.logging.Logger;

import com.jetdrone.vertx.yoke.middleware.YokeRequest;

public class PatchRequestImpl extends BodyRequestImpl implements PatchRequest {

	private final PatchResponseBuilder responseBuilder;

	public PatchRequestImpl(YokeRequest request, Deserializer deserializer, Serializer serializer, 
			EntityFactory entityFactory, MediaTypeStrategy mediaTypeStrategy,
			HashStrategy hashStrategy, Logger logger) {
		super(request, deserializer, serializer, entityFactory, mediaTypeStrategy, hashStrategy, logger);

		// Create ResponseBuilder
		this.responseBuilder = new PatchResponseBuilderImpl(this, response, entityFactory, serializer, hashStrategy, logger);

	}

	@Override
	public PatchResponseBuilder responseBuilder() {
		return responseBuilder;
	}

}
