package net.eusashead.parquet.http.request.impl;

import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.hash.HashStrategy;
import net.eusashead.parquet.http.conneg.MediaTypeStrategy;
import net.eusashead.parquet.http.request.OptionsRequest;
import net.eusashead.parquet.http.response.OptionsResponseBuilder;
import net.eusashead.parquet.http.response.impl.OptionsResponseBuilderImpl;
import net.eusashead.parquet.http.serializer.Deserializer;
import net.eusashead.parquet.http.serializer.Serializer;

import org.vertx.java.core.logging.Logger;

import com.jetdrone.vertx.yoke.middleware.YokeRequest;

public class OptionsRequestImpl extends RequestImpl implements OptionsRequest {

	private final OptionsResponseBuilder responseBuilder;

	public OptionsRequestImpl(YokeRequest request, Deserializer deserializer, Serializer serializer, 
			EntityFactory entityFactory, MediaTypeStrategy mediaTypeStrategy,
			HashStrategy hashStrategy, Logger logger) {
		super(request, deserializer, serializer, entityFactory, mediaTypeStrategy, hashStrategy, logger);

		// Create ResponseBuilder
		this.responseBuilder = new OptionsResponseBuilderImpl(this, response, entityFactory, serializer, hashStrategy, logger);

	}

	@Override
	public OptionsResponseBuilder responseBuilder() {
		return responseBuilder;
	}

}
