package net.eusashead.parquet.http.request.impl;

import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.hash.HashStrategy;
import net.eusashead.parquet.http.conneg.MediaTypeStrategy;
import net.eusashead.parquet.http.request.DeleteRequest;
import net.eusashead.parquet.http.response.DeleteResponseBuilder;
import net.eusashead.parquet.http.response.impl.DeleteResponseBuilderImpl;
import net.eusashead.parquet.http.serializer.Deserializer;
import net.eusashead.parquet.http.serializer.Serializer;

import org.vertx.java.core.logging.Logger;

import com.jetdrone.vertx.yoke.middleware.YokeRequest;

public class DeleteRequestImpl extends RequestImpl implements DeleteRequest {

	private final DeleteResponseBuilder responseBuilder;

	public DeleteRequestImpl(YokeRequest request, Deserializer deserializer, Serializer serializer, 
			EntityFactory entityFactory, MediaTypeStrategy mediaTypeStrategy,
			HashStrategy hashStrategy, Logger logger) {
		super(request, deserializer, serializer, entityFactory, mediaTypeStrategy, hashStrategy, logger);

		// Create ResponseBuilder
		this.responseBuilder = new DeleteResponseBuilderImpl(this, response, entityFactory, serializer, hashStrategy, logger);

	}

	@Override
	public DeleteResponseBuilder responseBuilder() {
		return responseBuilder;
	}

}
