package net.eusashead.parquet.http.request.impl;

import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.hash.HashStrategy;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.HttpStatus;
import net.eusashead.parquet.http.conneg.MediaTypeStrategy;
import net.eusashead.parquet.http.request.BodyRequest;
import net.eusashead.parquet.http.serializer.Deserializer;
import net.eusashead.parquet.http.serializer.Serializer;
import net.eusashead.parquet.util.Option;

import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.logging.Logger;

import com.jetdrone.vertx.yoke.middleware.YokeRequest;

public abstract class BodyRequestImpl extends RequestImpl implements BodyRequest {
	
	private Entity entity;
	
	public BodyRequestImpl(YokeRequest request, Deserializer deserializer, Serializer serializer, 
			EntityFactory entityFactory, MediaTypeStrategy mediaTypeStrategy,
			HashStrategy hashStrategy, Logger logger) {
		super(request, deserializer, serializer, entityFactory, mediaTypeStrategy, hashStrategy, logger);
		
		// Register the handler to set the body
		this.entityHandler(new Handler<Entity>() {

			@Override
			public void handle(Entity event) {
				entity = event;
			}
		});
	}
	
	@Override 
	public BodyRequest entityHandler(final Handler<Entity> handler) {
		request.bodyHandler(new Handler<Buffer>() {
			@Override
			public void handle(Buffer buffer) {
				
				try {
					final Option<ContentType> contentType = headers.contentType();
					if (contentType.has() && deserializer.supports(contentType.get())) {
						entity = deserializer.deserialize(buffer, contentType.get()); 
					    handler.handle(entity);
					} else {
						error(HttpStatus.UNSUPPORTED_MEDIA_TYPE).send();
					}
				} catch (Exception e) { 
					logger.warn("Invalid request body: " + buffer.toString());
					error(HttpStatus.BAD_REQUEST).send();
				}
			}
		});
		return this;
	}
	
	@Override
	public Entity body() {
		return this.entity;
	}

}
