package net.eusashead.parquet.http.request;

import net.eusashead.parquet.entity.Entity;

import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpServerRequest;

public interface BodyRequest extends Request {
	
	/**
	 * Returns the request entity as
	 * an {@link Entity} when the 
	 * body has been fully parsed.
	 * See {@link HttpServerRequest}
	 * bodyHandler() method.
	 * @param handler to process returned {@link Entity}
	 * @return this {@link BodyRequest}
	 */
	BodyRequest entityHandler(Handler<Entity> handler);

	/**
	 * Get the {@link Entity}
	 * body if it has been set
	 * @return the {@link Entity} or null
	 */
	Entity body();

}
