package net.eusashead.parquet.http.header;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import org.vertx.java.core.MultiMap;

public class AbstractHeaders implements Headers {
	
	protected final MultiMap headers;

	public AbstractHeaders(MultiMap headers) {
		super();
		this.headers = headers;
	}

	public boolean has(String name) {
		return this.headers.get(name) != null;
	}
	
	@Override
	public List<Entry<String,String>> entries() {
		return this.headers.entries();
	}

	@Override
	public List<String> getAll(String name) {
		return this.headers.getAll(name);
	}

	@Override
	public String get(String name) {
		return this.headers.get(name);
	}

	@Override
	public boolean contains(String name) {
		return this.headers.contains(name);
	}

	@Override
	public boolean isEmpty() {
		return this.headers.isEmpty();
	}

	@Override
	public Set<String> names() {
		return this.headers.names();
	}

	@Override
	public Headers add(String name, String value) {
		this.headers.add(name, value);
		return this;
	}

	@Override
	public Headers add(String name, Iterable<String> values) {
		this.headers.add(name, values);
		return this;
	}

	@Override
	public Headers add(MultiMap headers) {
		this.headers.add(headers);
		return this;
	}

	@Override
	public Headers add(Map<String, String> headers) {
		this.headers.add(headers);
		return this;
	}

	@Override
	public Headers set(String name, String value) {
		this.headers.set(name, value);
		return this;
	}

	@Override
	public Headers set(String name, Iterable<String> values) {
		this.headers.set(name, values);
		return this;
	}

	@Override
	public Headers set(MultiMap headers) {
		this.headers.set(headers);
		return this;
	}

	@Override
	public Headers set(Map<String, String> headers) {
		this.headers.set(headers);
		return this;
	}

	@Override
	public Headers remove(String name) {
		this.headers.remove(name);
		return this;
	}

	@Override
	public Headers clear() {
		this.headers.clear();
		return this;
	}

	@Override
	public int size() {
		return this.headers.size();
	}

	@Override
	public Iterator<Entry<String, String>> iterator() {
		return this.headers.iterator();
	}

	@Override
	public String get(CharSequence name) {
		return this.headers.get(name);
	}

	@Override
	public List<String> getAll(CharSequence name) {
		return this.getAll(name);
	}

	@Override
	public boolean contains(CharSequence name) {
		return this.headers.contains(name);
	}

	@Override
	public Headers add(CharSequence name, CharSequence value) {
		this.headers.add(name, value);
		return this;
	}

	@Override
	public Headers add(CharSequence name, Iterable<CharSequence> values) {
		this.headers.add(name, values);
		return this;
	}

	@Override
	public Headers set(CharSequence name, CharSequence value) {
		this.headers.set(name, value);
		return this;
	}

	@Override
	public Headers set(CharSequence name, Iterable<CharSequence> values) {
		this.headers.set(name, values);
		return this;
	}

	@Override
	public Headers remove(CharSequence name) {
		this.headers.remove(name);
		return this;
	}

}