package net.eusashead.parquet.http.handler;

import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.hash.HashStrategy;
import net.eusashead.parquet.http.HttpStatus;
import net.eusashead.parquet.http.conneg.MediaTypeStrategy;
import net.eusashead.parquet.http.request.Request;
import net.eusashead.parquet.http.response.ResponseException;
import net.eusashead.parquet.http.serializer.Deserializer;
import net.eusashead.parquet.http.serializer.Serializer;

import org.vertx.java.core.Handler;
import org.vertx.java.core.logging.Logger;

import com.jetdrone.vertx.yoke.Middleware;

public abstract class RequestHandlerDelegator<T extends Request> extends Middleware {

	protected final RequestHandler<T> delegate;
	protected final Deserializer deserializer;
	protected final Serializer serializer;
	protected final EntityFactory entityFactory;
	protected final MediaTypeStrategy mediaTypeStrategy;
	protected final HashStrategy hashStrategy;
	protected final Logger logger;
	
	
	public RequestHandlerDelegator(RequestHandler<T> delegate, Deserializer deserializer, Serializer serializer, 
			EntityFactory entityFactory, MediaTypeStrategy mediaTypeStrategy,
			HashStrategy hashStrategy, Logger logger) {
		this.delegate = delegate;
		this.deserializer = deserializer;
		this.serializer = serializer;
		this.entityFactory = entityFactory;
		this.mediaTypeStrategy = mediaTypeStrategy;
		this.hashStrategy = hashStrategy;
		this.logger = logger;
	}

	protected void handleInternal(T request, Handler<Object> next) {
		
		// Handle request
		try {
			delegate.handle(request, next);
		} catch (ResponseException e) {
			request.logger().warn(e.getLocalizedMessage(), e);
			request.error(e.status())
			  .body(e.getBody())
			  .send();
		} catch (Exception e) {
			request.logger().warn(e.getLocalizedMessage(), e);
			request.error(HttpStatus.INTERNAL_SERVER_ERROR)
			  .send();
		}
	}
}
