package net.eusashead.parquet.http.handler;

import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.hash.HashStrategy;
import net.eusashead.parquet.http.conneg.MediaTypeStrategy;
import net.eusashead.parquet.http.request.PatchRequest;
import net.eusashead.parquet.http.request.impl.PatchRequestImpl;
import net.eusashead.parquet.http.serializer.Deserializer;
import net.eusashead.parquet.http.serializer.Serializer;

import org.vertx.java.core.Handler;
import org.vertx.java.core.logging.Logger;

import com.jetdrone.vertx.yoke.middleware.YokeRequest;

public class PatchRequestHandlerDelegator extends RequestHandlerDelegator<PatchRequest> {

	public PatchRequestHandlerDelegator(RequestHandler<PatchRequest> delegate,
			Deserializer deserializer, Serializer serializer, 
			EntityFactory entityFactory, MediaTypeStrategy mediaTypeStrategy,
			HashStrategy hashStrategy, Logger logger) {
		super(delegate, deserializer, serializer, entityFactory, mediaTypeStrategy, hashStrategy, logger);
	}

	@Override
	public void handle(YokeRequest event, Handler<Object> next) {
		PatchRequest request = new PatchRequestImpl(event, deserializer, serializer, entityFactory, mediaTypeStrategy, hashStrategy, logger);
		handleInternal(request, next);
	}

}
