package net.eusashead.parquet.http.etag;



public interface ETag {

	/**
	 * Is the ETag weak 
	 * or strong validating
	 * @return {@link ETagValidation} type of the {@link ETag}
	 */
	ETagValidation type();

	/**
	 * String value of 
	 * the {@link ETag} not
	 * including the W/
	 * prefix for weak
	 * ETags
	 * @return
	 */
	String value();

	/**
	 * Weak validation 
	 * only considers the value of the
	 * ETag
	 * @param eTag
	 * @return true if values match
	 */
	boolean weakEquals(ETag eTag);

	/**
	 * Strong equals requires both
	 * ETags be strong
	 * 
	 * @param etags
	 * @return true if both ETags are strong and have the same value
	 */
	boolean strongEquals(ETag eTag);

	/**
	 * Weak validation 
	 * only considers the value of the
	 * ETag
	 * 
	 * @param encoded {@link String} value of {@link ETag}
	 * @return true if values match
	 */
	boolean weakEquals(String encoded);

	/**
	 * Strong equals requires both
	 * ETags be strong validating and the
	 * values to match in addition
	 * 
	 * @param encoded {@link String} value of {@link ETag}
	 * @return true if both ETags are strong and have the same value
	 */
	boolean strongEquals(String encoded);

	/**
	 * Write the {@link ETag} out 
	 * as an ASCII string including
	 * the W/ prefix for weak
	 * validating {@link ETag}
	 * @return
	 */
	String encode();

}