package net.eusashead.parquet.http.container;

import io.netty.handler.codec.http.HttpHeaders;
import net.eusashead.parquet.http.HttpStatus;

import org.vertx.java.core.Handler;

import com.jetdrone.vertx.yoke.middleware.YokeRequest;

public class TraceHandler implements Handler<YokeRequest> {

	@Override
	public void handle(YokeRequest request) {
		
		StringBuilder body = new StringBuilder();
		for (String header : request.headers().names()) {
			body.append(header + ": " + request.headers().get(header) + "\r\n");
		}
		request.response().headers().set(HttpHeaders.Names.CONTENT_TYPE, "message/http; charset=utf-8");
		request.response().setStatusCode(HttpStatus.OK.getCode()).end(body.toString());
	}

}
