package net.eusashead.parquet.http.container;

import io.netty.handler.codec.http.HttpHeaders;

import java.util.List;

import net.eusashead.parquet.http.HttpMethod;
import net.eusashead.parquet.http.HttpMethods;
import net.eusashead.parquet.http.HttpStatus;

import org.vertx.java.core.Handler;

import com.jetdrone.vertx.yoke.middleware.YokeRequest;

public class OptionsHandler implements Handler<YokeRequest> {

	private final List<HttpMethod> allowed;
	
	public OptionsHandler(List<HttpMethod> verbs) {
		this.allowed = verbs;
	}

	@Override
	public void handle(YokeRequest request) {
		HttpMethods header = new HttpMethods(allowed);
		request.response().headers().add(HttpHeaders.Names.ALLOW, header.toString());
		request.response().setStatusCode(HttpStatus.NO_CONTENT.getCode()).end();
	}

}
