package net.eusashead.parquet.http.container;

import io.netty.handler.codec.http.HttpHeaders;

import java.util.List;

import net.eusashead.parquet.http.HttpMethod;
import net.eusashead.parquet.http.HttpStatus;

import org.vertx.java.core.Handler;

import com.jetdrone.vertx.yoke.middleware.YokeRequest;

public class MethodNotAllowedHandler implements Handler<YokeRequest> {

	private final String allow;

	public MethodNotAllowedHandler(List<HttpMethod> supported) {
		StringBuilder allowBuilder = new StringBuilder();
		int count = 0;
		for (HttpMethod verb : supported) {
			allowBuilder.append(verb.toString());
			if (++count < supported.size()) {
				allowBuilder.append(",");
			}
		}
		this.allow = allowBuilder.toString();
	}

	@Override
	public void handle(YokeRequest request) {
		request
			.response()
			.headers()
			.add(HttpHeaders.Names.ALLOW, allow);
		request
			.response()
			.setStatusCode(HttpStatus.METHOD_NOT_ALLOWED.getCode())
			.end();
	}

}
