package net.eusashead.parquet.http.conneg.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import net.eusashead.parquet.http.MediaType;
import net.eusashead.parquet.http.conneg.AcceptableMediaType;
import net.eusashead.parquet.http.conneg.MediaTypeStrategy;

import org.vertx.java.core.http.HttpServerRequest;

public class PathExtensionMediaTypeStrategy implements MediaTypeStrategy {

	private final Map<String, MediaType> mappings;

	public PathExtensionMediaTypeStrategy(Map<String, MediaType> mappings) {
		this.mappings = Collections.unmodifiableMap(mappings);
	}

	@Override
	public Set<AcceptableMediaType> acceptableMediaTypes(
			HttpServerRequest request) {
		
		// Set of acceptable media types and q values
		Set<AcceptableMediaType> acceptable = new TreeSet<>();
				
		// Get the path extension
		String extension = "";
		String fileName = request.path();
		int i = fileName.lastIndexOf('.');
		if (i > 0) {
			extension = fileName.substring(i+1);
		}

		// Get the requested content type
		if (mappings.containsKey(extension)) {
			MediaType mediaType = mappings.get(extension);
			acceptable.add(new AcceptableMediaType(1.0d, mediaType));
		}
		
		return acceptable;
	}

}
