package net.eusashead.parquet.http.conneg.impl;

import io.netty.handler.codec.http.HttpHeaders;

import java.util.Set;
import java.util.TreeSet;

import net.eusashead.parquet.http.conneg.AcceptableMediaType;
import net.eusashead.parquet.http.conneg.MediaTypeStrategy;

import org.vertx.java.core.http.HttpServerRequest;

public class AcceptHeaderMediaTypeStrategy implements MediaTypeStrategy {

	@Override
	public Set<AcceptableMediaType> acceptableMediaTypes(HttpServerRequest request) {

		// Set of acceptable media types and q values
		Set<AcceptableMediaType> acceptable = new TreeSet<>();

		// Header value
		String acceptHeader = request.headers().get(HttpHeaders.Names.ACCEPT);

		// Split into all acceptable types
		if (acceptHeader != null) {
			for (String accept : acceptHeader.split(",")){
				AcceptableMediaType a = AcceptableMediaType.parse(accept);
				acceptable.add(a);
			}
		}
		return acceptable;
	}

}
