package net.eusashead.parquet.http.conneg;

import java.util.Set;

import org.vertx.java.core.http.HttpServerRequest;

public interface MediaTypeStrategy {
	
	/**
	 * Get the {@link AcceptableMediaType}
	 * set for this request. Implementations 
	 * include extracting from Accept header
	 * or from file path extension
	 * @param request {@link HttpServerRequest}
	 * @return {@link Set} of {@link AcceptableMediaType}
	 */
	Set<AcceptableMediaType> acceptableMediaTypes(HttpServerRequest request);

}
