package net.eusashead.parquet.http.conneg;

import net.eusashead.parquet.http.MediaType;

import org.apache.commons.lang3.StringUtils;

public class AcceptableMediaType implements Q, Comparable<AcceptableMediaType> {

	private final Double q;
	private final MediaType mediaType;

	public AcceptableMediaType(Double q, MediaType mediaType) {
		this.q = q;
		this.mediaType = mediaType;
	}

	@Override
	public Double q() {
		return this.q;
	}

	public MediaType mediaType() {
		return this.mediaType;
	}

	@Override
	public int compareTo(AcceptableMediaType o) {
		int compareQ = o.q().compareTo(this.q());
		if (compareQ != 0) {
			return compareQ;
		} else {
			return mediaType.toString().compareTo(o.mediaType.toString());
		}
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((mediaType == null) ? 0 : mediaType.hashCode());
		result = prime * result + ((q == null) ? 0 : q.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AcceptableMediaType other = (AcceptableMediaType) obj;
		if (mediaType == null) {
			if (other.mediaType != null)
				return false;
		} else if (!mediaType.equals(other.mediaType))
			return false;
		if (q == null) {
			if (other.q != null)
				return false;
		} else if (!q.equals(other.q))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder
		.append(mediaType).append(";")
		.append("q=").append(q);
		return builder.toString();
	}

	public static AcceptableMediaType parse(String accept) {
		
		// Split "q" and media type part
		String[] parts = StringUtils.split(StringUtils.deleteWhitespace(accept), ';');

		// Initial values for media type and q
		MediaType mediaType = null;
		Double q = 1.0d;

		// Parse the media type and q
		if (parts != null) {
			// The media type should be the first part
			if (parts.length >=1) {
				mediaType = MediaType.parse(parts[0]);
			}
			// The q should be the second part
			if (parts.length >=2) {
				q = Double.parseDouble(parts[1].substring(2).trim());
			}
		}

		return new AcceptableMediaType(q, mediaType);

	}

}
