package net.eusashead.parquet.http.conneg;

import java.util.Locale;

import org.apache.commons.lang3.StringUtils;

public class AcceptableLanguage implements Q, Comparable<AcceptableLanguage> {
	
	private final Double q;
	private final Locale language;
	
	public AcceptableLanguage(Double q, Locale language) {
		this.q = q;
		this.language = language;
	}

	@Override
	public Double q() {
		return this.q;
	}
	
	public Locale language() {
		return this.language;
	}
	
	@Override
	public int compareTo(AcceptableLanguage o) {
		int compareQ = o.q().compareTo(this.q());
		if (compareQ != 0) {
			return compareQ;
		} else {
			return language.toString().compareTo(o.language.toString());
		}
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((language == null) ? 0 : language.hashCode());
		result = prime * result + ((q == null) ? 0 : q.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AcceptableLanguage other = (AcceptableLanguage) obj;
		if (language == null) {
			if (other.language != null)
				return false;
		} else if (!language.equals(other.language))
			return false;
		if (q == null) {
			if (other.q != null)
				return false;
		} else if (!q.equals(other.q))
			return false;
		return true;
	}
	
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder
		  .append(language).append(";")
		  .append("q=").append(q);
		return builder.toString();
	}

	public static AcceptableLanguage parse(String accept) {
		// Split "q" and language part
		String[] parts = StringUtils.split(StringUtils.deleteWhitespace(accept), ';');

		// Initial values for charset and q
		Locale locale = null;
		Double q = 1.0d;

		// Parse the charset and q
		if (parts != null) {
			// The charset should be the first part
			if (parts.length >=1) {
				locale = Locale.forLanguageTag(parts[0]);
			}
			// The q should be the second part
			if (parts.length >=2) {
				q = Double.parseDouble(parts[1].substring(2).trim());
			}
		}

		// Create AcceptableContentType
		return new AcceptableLanguage(q, locale);
	}

}
