package net.eusashead.parquet.http.conneg;

import net.eusashead.parquet.http.ContentType;

public class AcceptableContentType implements Q, Comparable<AcceptableContentType> {
	
	private final Double q;
	private final ContentType contentType;
	
	public AcceptableContentType(Double q, ContentType contentType) {
		this.q = q;
		this.contentType = contentType;
	}

	@Override
	public Double q() {
		return this.q;
	}
	
	public ContentType contentType() {
		return this.contentType;
	}
	
	@Override
	public int compareTo(AcceptableContentType o) {
		int compareQ = o.q().compareTo(this.q());
		if (compareQ != 0) {
			return compareQ;
		} else {
			return contentType.toString().compareTo(o.contentType.toString());
		}
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((contentType == null) ? 0 : contentType.hashCode());
		result = prime * result + ((q == null) ? 0 : q.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AcceptableContentType other = (AcceptableContentType) obj;
		if (contentType == null) {
			if (other.contentType != null)
				return false;
		} else if (!contentType.equals(other.contentType))
			return false;
		if (q == null) {
			if (other.q != null)
				return false;
		} else if (!q.equals(other.q))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder
		  .append(contentType).append(";")
		  .append("q=").append(q);
		return builder.toString();
	}

}
