package net.eusashead.parquet.http.conneg;

import org.apache.commons.lang3.StringUtils;

import net.eusashead.parquet.http.Charset;

public class AcceptableCharset implements Q, Comparable<AcceptableCharset> {
	
	private final Double q;
	private final Charset charset;
	
	public AcceptableCharset(Double q, Charset charset) {
		this.q = q;
		this.charset = charset;
	}

	@Override
	public Double q() {
		return this.q;
	}
	
	public Charset charset() {
		return this.charset;
	}
	
	@Override
	public int compareTo(AcceptableCharset o) {
		int compareQ = o.q().compareTo(this.q());
		if (compareQ != 0) {
			return compareQ;
		} else {
			return charset.compareTo(o.charset);
		}
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((charset == null) ? 0 : charset.hashCode());
		result = prime * result + ((q == null) ? 0 : q.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AcceptableCharset other = (AcceptableCharset) obj;
		if (charset == null) {
			if (other.charset != null)
				return false;
		} else if (!charset.equals(other.charset))
			return false;
		if (q == null) {
			if (other.q != null)
				return false;
		} else if (!q.equals(other.q))
			return false;
		return true;
	}
	
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder
		  .append(charset).append(";")
		  .append("q=").append(q);
		return builder.toString();
	}

	public static AcceptableCharset parse(String accept) {
		// Split "q" and charset part
		String[] parts = StringUtils.split(StringUtils.deleteWhitespace(accept), ';');

		// Initial values for charset and q
		Charset charset = null;
		Double q = 1.0d;

		// Parse the charset and q
		if (parts != null) {
			// The charset should be the first part
			if (parts.length >=1) {
				charset = new Charset(parts[0]);
			}
			// The q should be the second part
			if (parts.length >=2) {
				q = Double.parseDouble(parts[1].substring(2).trim());
			}
		}

		// Create AcceptableCharset
		return new AcceptableCharset(q, charset);
	}

}
