package net.eusashead.parquet.http;

import java.nio.charset.Charset;
import java.util.Locale;

@Deprecated
public class Variant {
	
	private final ContentType contentType;
	private final Charset charset;
	private final String encoding;
	private final Locale language;
	
	public Variant(ContentType contentType, Charset charset) {
		this.contentType = contentType;
		this.charset = charset;
		this.encoding = null;
		this.language = Locale.getDefault();
	}
	
	public Variant(ContentType contentType, Charset charset, String encoding, Locale language) {
		this.contentType = contentType;
		this.charset = charset;
		this.encoding = encoding;
		this.language = language;
	}
	
	public ContentType contentType() {
		return contentType;
	}
	
	public Charset charset() {
		return charset;
	}
	
	public String encoding() {
		return encoding;
	}
	
	public Locale language() {
		return language;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((charset == null) ? 0 : charset.hashCode());
		result = prime * result
				+ ((contentType == null) ? 0 : contentType.hashCode());
		result = prime * result
				+ ((encoding == null) ? 0 : encoding.hashCode());
		result = prime * result
				+ ((language == null) ? 0 : language.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Variant other = (Variant) obj;
		if (charset == null) {
			if (other.charset != null)
				return false;
		} else if (!charset.equals(other.charset))
			return false;
		if (contentType == null) {
			if (other.contentType != null)
				return false;
		} else if (!contentType.equals(other.contentType))
			return false;
		if (encoding == null) {
			if (other.encoding != null)
				return false;
		} else if (!encoding.equals(other.encoding))
			return false;
		if (language == null) {
			if (other.language != null)
				return false;
		} else if (!language.equals(other.language))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("Variant [contentType=").append(contentType)
				.append(", charset=").append(charset).append(", encoding=")
				.append(encoding).append(", language=").append(language)
				.append("]");
		return builder.toString();
	}
	
}
