package net.eusashead.parquet.http;

public enum HttpStatus {

	OK(200),
	CREATED(201),
	NO_CONTENT(204),
	NOT_MODIFIED(304),
	BAD_REQUEST(400),
	UNAUTHORIZED(401),
	NOT_FOUND(404),
	METHOD_NOT_ALLOWED(405),
	NOT_ACCEPTABLE(406),
	PRECONDITION_FAILED(412),
	UNSUPPORTED_MEDIA_TYPE(415),
	PRECONDITION_REQUIRED(428), 
	INTERNAL_SERVER_ERROR(500),
	NOT_IMPLEMENTED(501);

	private int statusCode;

	private HttpStatus(int statusCode) {
		this.statusCode = statusCode;
	}

	public int getCode() {
		return this.statusCode;
	}
}
