package net.eusashead.parquet.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.apache.commons.lang3.StringUtils;

public class HttpMethods implements Iterable<HttpMethod> {

	private Set<HttpMethod> methods = new TreeSet<>();
	
	public HttpMethods(Collection<HttpMethod> methods) {
		this.methods.addAll(methods);
	}

	@Override
	public Iterator<HttpMethod> iterator() {
		return methods.iterator();
	}
	
	@Override
	public String toString() {
		StringBuilder bldr = new StringBuilder();
		for (HttpMethod meth : methods) {
			bldr.append(meth.name());
			bldr.append(",");
		}
		return bldr.substring(0, bldr.length() - 1);
	}

	public static HttpMethods parse(String allowHeader) {
		List<HttpMethod> allow = new ArrayList<>();
		for (String verb : StringUtils.split(allowHeader, ",")) {
			allow.add(HttpMethod.valueOf(verb));
		}
		return new HttpMethods(allow);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((methods == null) ? 0 : methods.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		HttpMethods other = (HttpMethods) obj;
		if (methods == null) {
			if (other.methods != null)
				return false;
		} else if (!methods.equals(other.methods))
			return false;
		return true;
	}
	
	

}
