package net.eusashead.parquet.http;

public interface Compatible<T> {
	
	/**
	 * Return true if this
	 * {@link Compatible} instance
	 * could be safely replaced
	 * with the supplied other
	 * {@link Compatible}
	 * 
	 * Note compatibility is not symmetric
	 * x.compatible(y) does NOT mean 
	 * y.compatible(x). Example:
	 * application/json is compatible with (can replace) application/* 
	 * application/* is not compatible with (cannot replace) application/json 
	 * 
	 * wildcard.compatible(json) = true
	 * json.compatible(wildcard) = false
	 * 
	 * Neither is it transitive.
	 * x.compatible(y) and z.compatible(y)
	 * does not imply z.compatible(z). Example:
	 * 
	 * application/json is compatible with application/*
	 * application/xml is compatible with application/*
	 * application/xml is not compatible with application/json
	 * 
	 * @param other another {@link Compatible} instance 
	 * @return true if this {@link Compatible} could be replaced by the other
	 */
	boolean compatible(T other);
	
}
