package net.eusashead.parquet.http;

public class CacheControl {
	
	private final long maxAge;

	public CacheControl(long maxAge) {
		this.maxAge = maxAge;
	}
	
	public long maxAge() {
		return this.maxAge;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("public, ");
		builder.append("must-revalidate, ");
		builder.append("proxy-revalidate, ");
		builder.append(String.format("max-age=%d", maxAge/1000));
		return builder.toString();
	}

	
}
