/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.test;

import java.util.Map;
import java.util.TreeSet;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.testtools.VertxAssert;

public abstract class ResponseHandler
implements Handler<HttpClientResponse> {
    protected final String[] expectHeaders;
    protected final Map<String, String> assertHeaders;

    public ResponseHandler(String[] expectHeaders, Map<String, String> assertHeaders) {
        this.expectHeaders = expectHeaders;
        this.assertHeaders = assertHeaders;
    }

    protected void expectHeaders(HttpClientResponse resp) {
        TreeSet<String> expectedSet = new TreeSet<String>();
        TreeSet<String> actualSet = new TreeSet<String>();
        for (String expect : this.expectHeaders) {
            expectedSet.add(expect.toLowerCase());
        }
        for (String actual : resp.headers().names()) {
            actualSet.add(actual.toLowerCase());
        }
        VertxAssert.assertEquals(expectedSet, actualSet);
    }

    protected void assertHeaders(HttpClientResponse resp, String ... headers) {
        for (String header : this.assertHeaders.keySet()) {
            VertxAssert.assertEquals((Object)this.assertHeaders.get(header), (Object)resp.headers().get(header));
        }
    }
}

