/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.test;

import java.util.HashMap;
import java.util.Map;
import net.eusashead.parquet.http.HttpStatus;
import net.eusashead.parquet.http.serializer.Body;
import net.eusashead.parquet.http.serializer.Deserializer;
import net.eusashead.parquet.test.BodilessResponseHandler;
import net.eusashead.parquet.test.BodyResponseHandler;
import net.eusashead.parquet.test.ResponseHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientRequest;

public class RequestBuilder<T> {
    private final HttpClient client;
    private final Map<String, String> requestHeaders = new HashMap<String, String>();
    private final Map<String, String> responseHeaders = new HashMap<String, String>();
    private String[] expectHeaders = new String[0];
    private String uri;
    private HttpStatus status;
    private String requestBody;
    private boolean expectBody;
    private T assertBody;
    private Deserializer deserializer;
    private boolean printBody = false;

    public RequestBuilder(HttpClient client) {
        this.client = client;
    }

    public RequestBuilder<T> uri(String uri) {
        this.uri = uri;
        return this;
    }

    public RequestBuilder<T> assertStatus(HttpStatus status) {
        this.status = status;
        return this;
    }

    public RequestBuilder<T> requestHeader(String header, String value) {
        this.requestHeaders.put(header, value);
        return this;
    }

    public RequestBuilder<T> assertHeader(String header, String value) {
        this.responseHeaders.put(header, value);
        return this;
    }

    public RequestBuilder<T> expectHeaders(String ... headers) {
        this.expectHeaders = headers;
        return this;
    }

    public RequestBuilder<T> requestBody(Body body) {
        this.requestBody = body.buffer().toString();
        this.requestHeaders.put("Content-Length", Integer.valueOf(body.buffer().toString().length()).toString());
        this.requestHeaders.put("Content-Type", body.contentType().toString());
        return this;
    }

    public RequestBuilder<T> expectBody(Deserializer deserializer) {
        this.expectBody = true;
        this.deserializer = deserializer;
        return this;
    }

    public RequestBuilder<T> assertBody(T body) {
        this.assertBody = body;
        return this;
    }

    public RequestBuilder<T> printBody() {
        this.printBody = true;
        return this;
    }

    public void options() {
        HttpClientRequest request = this.client.options(this.uri, (Handler)this.handler());
        this.setRequestHeaders(request);
        request.end();
    }

    public void get() {
        HttpClientRequest request = this.client.get(this.uri, (Handler)this.handler());
        this.setRequestHeaders(request);
        request.end();
    }

    public void head() {
        HttpClientRequest request = this.client.head(this.uri, (Handler)this.handler());
        this.setRequestHeaders(request);
        request.end();
    }

    public void put() {
        HttpClientRequest request = this.client.put(this.uri, (Handler)this.handler());
        this.setRequestHeaders(request);
        request.write(this.requestBody);
        request.end();
    }

    public void post() {
        HttpClientRequest request = this.client.post(this.uri, (Handler)this.handler());
        this.setRequestHeaders(request);
        request.write(this.requestBody);
        request.end();
    }

    public void delete() {
        HttpClientRequest request = this.client.delete(this.uri, (Handler)this.handler());
        this.setRequestHeaders(request);
        request.end();
    }

    public void trace() {
        HttpClientRequest request = this.client.trace(this.uri, (Handler)this.handler());
        this.setRequestHeaders(request);
        request.end();
    }

    public void connect() {
        HttpClientRequest request = this.client.connect(this.uri, (Handler)this.handler());
        this.setRequestHeaders(request);
        request.end();
    }

    private ResponseHandler handler() {
        return this.expectBody ? this.bodyHandler() : this.bodilessHandler();
    }

    private BodyResponseHandler bodyHandler() {
        return new BodyResponseHandler(this.status, this.expectHeaders, this.responseHeaders, this.deserializer, this.assertBody, this.printBody);
    }

    private BodilessResponseHandler bodilessHandler() {
        return new BodilessResponseHandler(this.status, this.expectHeaders, this.responseHeaders);
    }

    private void setRequestHeaders(HttpClientRequest request) {
        for (String header : this.requestHeaders.keySet()) {
            request.headers().add(header, this.requestHeaders.get(header));
        }
    }
}

