/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.test;

import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.serializer.Deserializer;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.testtools.VertxAssert;

public class BodyHandler
implements Handler<Buffer> {
    private final HttpClientResponse response;
    private final Deserializer deserializer;
    private final Object assertBody;
    private final boolean printBody;

    public BodyHandler(HttpClientResponse response, Deserializer deserializer, Object assertBody, boolean printBody) {
        this.response = response;
        this.deserializer = deserializer;
        this.assertBody = assertBody;
        this.printBody = printBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Buffer event) {
        try {
            if (event != null && event.getBytes() != null) {
                if (this.printBody) {
                    System.out.println(new String(event.getBytes()));
                }
                Entity obj = this.deserializer.deserialize(event, ContentType.parse((String)this.response.headers().get("Content-Type")));
                if (this.assertBody != null) {
                    VertxAssert.assertEquals((Object)this.assertBody, (Object)obj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            VertxAssert.handleThrowable((Throwable)e);
        }
        finally {
            VertxAssert.testComplete();
        }
    }
}

