package net.eusashead.parquet.test;

import static org.vertx.testtools.VertxAssert.assertEquals;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpClientResponse;

public abstract class ResponseHandler implements Handler<HttpClientResponse> {

	protected final String[] expectHeaders;
	protected final Map<String, String> assertHeaders;

	public ResponseHandler(String[] expectHeaders, Map<String, String> assertHeaders) {
		this.expectHeaders = expectHeaders;
		this.assertHeaders = assertHeaders;
	}

	/**
	 * Compare the expected set of
	 * response headers with the actual
	 * returned headers, ignoring case.
	 * @param resp
	 */
	protected void expectHeaders(HttpClientResponse resp) {
		Set<String> expectedSet = new TreeSet<>();
		Set<String> actualSet = new TreeSet<>();
		for (String expect : expectHeaders) {
			expectedSet.add(expect.toLowerCase());
		}
		for (String actual : resp.headers().names()) {
			actualSet.add(actual.toLowerCase());
		}
		assertEquals(expectedSet, actualSet);
	}

	protected void assertHeaders(HttpClientResponse resp, String... headers) {
		for (String header : assertHeaders.keySet()) {
			assertEquals(assertHeaders.get(header), resp.headers().get(header));
		}
	}

}