package net.eusashead.parquet.test;

import java.util.Arrays;
import java.util.List;

import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.http.Charset;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.MediaType;
import net.eusashead.parquet.http.serializer.DeserializationException;
import net.eusashead.parquet.http.serializer.Deserializer;

import org.vertx.java.core.buffer.Buffer;

public class NullDeserializer implements Deserializer {

	private static final ContentType[] supported = new ContentType[]{
		new ContentType(new MediaType("message", "http"), Charset.UTF8),
		new ContentType(new MediaType("text", "html"), Charset.ANY)
	};
	
	private final EntityFactory entityFactory;
	
	public NullDeserializer(EntityFactory entityFactory) {
		this.entityFactory = entityFactory;
	}
	
	@Override
	public boolean supports(ContentType contentType) {
		return contentTypes().contains(contentType);
	}

	@Override
	public List<ContentType> contentTypes() {
		return Arrays.asList(supported);
	}

	@Override
	public Entity deserialize(Buffer body, ContentType contentType)
			throws DeserializationException {
		return entityFactory.newEntity().build();
	}
	
}