package net.eusashead.parquet.test;

import static org.vertx.testtools.VertxAssert.assertEquals;

import java.util.Map;

import net.eusashead.parquet.http.HttpStatus;
import net.eusashead.parquet.http.serializer.Deserializer;

import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpClientResponse;

public class BodyResponseHandler extends ResponseHandler implements Handler<HttpClientResponse> {

	private final HttpStatus code;
	private final Deserializer deserializer;
	private final Object assertBody;
	private final boolean printBody;

	public BodyResponseHandler(HttpStatus code, String[] expectHeaders, Map<String, String> assertHeaders, Deserializer deserializer, Object assertBody, boolean printBody) {
		super(expectHeaders, assertHeaders);
		this.code = code;
		this.deserializer = deserializer;
		this.assertBody = assertBody;
		this.printBody = printBody;
	}

	@Override
	public void handle(final HttpClientResponse resp) {
		assertEquals(code.getCode(), resp.statusCode());
		expectHeaders(resp);
		assertHeaders(resp);
		resp.bodyHandler(new BodyHandler(resp, deserializer, assertBody, printBody));

	}

}