package net.eusashead.parquet.test;

import static org.vertx.testtools.VertxAssert.assertEquals;
import static org.vertx.testtools.VertxAssert.testComplete;
import io.netty.handler.codec.http.HttpHeaders;
import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.serializer.Deserializer;

import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.testtools.VertxAssert;

public class BodyHandler implements Handler<Buffer> {

	private final HttpClientResponse response;
	private final Deserializer deserializer;
	private final Object assertBody;
	private final boolean printBody;

	public BodyHandler(HttpClientResponse response, Deserializer deserializer, Object assertBody, boolean printBody) {
		this.response = response;
		this.deserializer = deserializer;
		this.assertBody = assertBody;
		this.printBody = printBody;
	}

	@Override
	public void handle(Buffer event) {
		try {
			if (event != null && event.getBytes() != null) {
				
				// Print body 
				if (printBody) {
					System.out.println(new String(event.getBytes()));
				}

				// Deserialize
				Entity obj = deserializer.deserialize(event, ContentType.parse(response.headers().get(HttpHeaders.Names.CONTENT_TYPE)));

				// Assert body
				if (assertBody != null) {
					assertEquals(assertBody, obj);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			VertxAssert.handleThrowable(e);
		}
		finally {
			testComplete();
		}
	}
}