package net.eusashead.parquet.test;

import static org.vertx.testtools.VertxAssert.assertEquals;
import static org.vertx.testtools.VertxAssert.assertTrue;
import static org.vertx.testtools.VertxAssert.testComplete;

import java.util.Map;

import net.eusashead.parquet.http.HttpStatus;

import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClientResponse;

public class BodilessResponseHandler extends ResponseHandler implements Handler<HttpClientResponse> {

	private final HttpStatus code;

	public BodilessResponseHandler(HttpStatus code, String[] expectHeaders, Map<String, String> assertHeaders) {
		super(expectHeaders, assertHeaders);
		this.code = code;
	}

	@Override
	public void handle(final HttpClientResponse resp) {
		
		assertEquals(code.getCode(), resp.statusCode());
		expectHeaders(resp);
		assertHeaders(resp);
		resp.bodyHandler(new Handler<Buffer>() {

			@Override
			public void handle(Buffer event) {
				assertTrue(event.getBytes().length == 0);
				testComplete();
			}
		});
	}

}