/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.entity.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.EntityBuilder;
import net.eusashead.parquet.entity.EntityConverter;
import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.entity.Link;
import net.eusashead.parquet.entity.PropertyConverter;
import net.eusashead.parquet.entity.impl.BasicEntity;

public class BasicEntityBuilder
implements EntityBuilder {
    private final ConcurrentMap<String, Link> links = new ConcurrentHashMap<String, Link>();
    private final ConcurrentMap<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final ConcurrentMap<String, Collection<Entity>> relations = new ConcurrentHashMap<String, Collection<Entity>>();
    private final EntityFactory factory;

    BasicEntityBuilder(EntityFactory factory) {
        this.factory = factory;
    }

    BasicEntityBuilder(URI self, EntityFactory factory) {
        if (self != null) {
            this.links.put("self", Link.self(self));
        }
        this.factory = factory;
    }

    public BasicEntityBuilder(Entity entity, EntityFactory factory) {
        this.copyEntity(entity);
        this.factory = factory;
    }

    @Override
    public EntityBuilder property(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    @Override
    public EntityBuilder property(String name, Object value, PropertyConverter<?, Object> converter) {
        this.properties.put(name, converter.convert(value));
        return this;
    }

    @Override
    public EntityBuilder embed(String name, Entity entity) {
        ArrayList<Entity> rels = new ArrayList<Entity>();
        rels.add(entity);
        Collection existing = this.relations.putIfAbsent(name, rels);
        if (existing != null) {
            existing.add(entity);
        }
        return this;
    }

    @Override
    public <T> EntityBuilder embed(String name, T target, EntityConverter<T> converter) {
        EntityBuilder converted = converter.convert(target, this.factory);
        ArrayList<Entity> rels = new ArrayList<Entity>();
        rels.add(converted.build());
        Collection existing = this.relations.putIfAbsent(name, rels);
        if (existing != null) {
            existing.add(converted.build());
        }
        return this;
    }

    @Override
    public EntityBuilder link(Link link) {
        this.links.put(link.rel(), link);
        return this;
    }

    @Override
    public <T> EntityBuilder forEach(String rel, Iterable<T> target, EntityConverter<T> converter) {
        ArrayList<Entity> rels = new ArrayList<Entity>();
        for (T t : target) {
            EntityBuilder converted = converter.convert(t, this.factory);
            rels.add(converted.build());
        }
        Collection existing = this.relations.putIfAbsent(rel, rels);
        if (existing != null) {
            existing.addAll(rels);
        }
        return this;
    }

    @Override
    public EntityBuilder append(Entity entity) {
        this.copyEntity(entity);
        return this;
    }

    @Override
    public <T> EntityBuilder append(T target, EntityConverter<T> converter) {
        this.copyEntity(converter.convert(target, this.factory).build());
        return this;
    }

    @Override
    public Entity build() {
        return new BasicEntity(this.links, this.properties, this.relations, this.factory);
    }

    @Override
    public EntityFactory entityFactory() {
        return this.factory;
    }

    private void copyEntity(Entity entity) {
        if (entity != null) {
            this.links.putAll(entity.getLinks());
            this.properties.putAll(entity.getProperties());
            this.relations.putAll(entity.getRelations());
        }
    }

    @Override
    public boolean empty() {
        return this.links.size() == 0 && this.properties.size() == 0 && this.relations.size() == 0;
    }
}

