/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.entity.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.EntityBuilder;
import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.entity.Link;
import net.eusashead.parquet.entity.PropertyConverter;

public class BasicEntity
implements Entity,
Serializable {
    private static final long serialVersionUID = 1570686849513215182L;
    private final Map<String, Link> links;
    private final Map<String, Object> properties;
    private final Map<String, Collection<Entity>> relations;
    private final EntityFactory entityFactory;

    BasicEntity(Map<String, Link> links, Map<String, Object> properties, Map<String, Collection<Entity>> relations, EntityFactory entityFactory) {
        this.links = Collections.unmodifiableMap(links);
        this.properties = Collections.unmodifiableMap(properties);
        this.relations = Collections.unmodifiableMap(relations);
        this.entityFactory = entityFactory;
    }

    @Override
    public String getProperty(String name, Format format) {
        return format.format(this.properties.get(name));
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public <T> T getProperty(String name, Class<T> convertTo) {
        return convertTo.cast(this.getProperty(name));
    }

    @Override
    public <T> T getProperty(String name, PropertyConverter<T, Object> converter) {
        return converter.convert(this.getProperty(name));
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, Collection<Entity>> getRelations() {
        return this.relations;
    }

    @Override
    public Collection<Entity> getRelation(String rel) {
        return this.relations.get(rel);
    }

    @Override
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    public Link getLink(String rel) {
        return this.links.get(rel);
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        aOutputStream.defaultWriteObject();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.links == null ? 0 : this.links.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.relations == null ? 0 : this.relations.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicEntity other = (BasicEntity)obj;
        if (this.links == null ? other.links != null : !this.links.equals(other.links)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return !(this.relations == null ? other.relations != null : !this.relations.equals(other.relations));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BasicEntity [links=").append(this.links).append(", properties=").append(this.properties).append(", relations=").append(this.relations).append("]");
        return builder.toString();
    }

    @Override
    public EntityBuilder entityBuilder() {
        EntityBuilder builder = this.entityFactory.newEntity();
        builder.append(this);
        return builder;
    }
}

