/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.entity;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.eusashead.parquet.entity.LinkException;

public class UriBuilder {
    private static final String SEPARATOR = "/";
    private final StringBuilder path;
    private final ConcurrentMap<String, List<String>> params;
    private String lastSegment;

    public UriBuilder() {
        this.path = new StringBuilder();
        this.params = new ConcurrentHashMap<String, List<String>>();
        this.lastSegment = "";
    }

    public UriBuilder(String initialPath) {
        this.path = new StringBuilder(initialPath);
        this.params = new ConcurrentHashMap<String, List<String>>();
        this.lastSegment = "";
    }

    public UriBuilder(UriBuilder clone) {
        this.path = new StringBuilder(clone.path);
        this.params = new ConcurrentHashMap<String, List<String>>(clone.params);
        this.lastSegment = clone.lastSegment;
    }

    public UriBuilder slash() {
        return this.slash("");
    }

    public UriBuilder slash(String segment) {
        this.addSlash(segment);
        this.path.append(segment);
        this.lastSegment = segment;
        return this;
    }

    private void addSlash(String segment) {
        if (!segment.startsWith(SEPARATOR) && !this.lastSegment.endsWith(SEPARATOR)) {
            this.path.append(SEPARATOR);
        }
    }

    public UriBuilder param(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        List existing = this.params.putIfAbsent(name, values);
        if (existing != null) {
            existing.add(value);
        }
        return this;
    }

    public UriBuilder params(Map<String, List<String>> params) {
        this.params.putAll(params);
        return this;
    }

    public URI build() {
        if (this.params.size() > 0) {
            this.path.append("?");
            for (Map.Entry entry : this.params.entrySet()) {
                int count = 0;
                for (String val : (List)entry.getValue()) {
                    ++count;
                    this.path.append((String)entry.getKey());
                    this.path.append("=");
                    this.path.append(val);
                    if (count >= this.params.size()) continue;
                    this.path.append("&");
                }
            }
        }
        try {
            return new URI(this.path.toString());
        }
        catch (URISyntaxException e) {
            throw new LinkException(e);
        }
    }
}

