package net.eusashead.parquet.entity;


public interface MutableEntity {
	
	/**
	 * Embed the supplied value
	 * as a property under the supplied name
	 * @param name {@link String} name of property
	 * @param value {@link Object} value of property
	 * @return the current {@link EntityBuilder}
	 */
	MutableEntity property(String name, Object value);
	
	/**
	 * Embed the supplied String value
	 * as a property under the supplied name
	 * after converting it to an Object
	 * @param name {@link String} property name
	 * @param value {@link Object} property value
	 * @param converter {@link PropertyConverter} to convert to object
	 * @return the current {@link EntityBuilder}
	 */
	MutableEntity property(String name, Object value, PropertyConverter<?,Object> converter);
	
	/**
	 * Embed an existing {@link Entity} 
	 * with the specified rel
	 * @param rel {@link String} name of the related {@link Entity}
	 * @param entity {@link Entity} to embed
	 * @return the current {@link EntityBuilder}
	 */
	MutableEntity embed(String rel, Entity entity);
	
	/**
	 * Convert the supplied target object
	 * to an {@link Entity} using the 
	 * supplied {@link EntityConverter}
	 * @param rel {@link String} name of the related {@link Entity}
	 * @param target {@link Object} to convert to {@link Entity}
	 * @param converter {@link EntityConverter} to perform conversion
	 * @return the current {@link EntityBuilder}
	 */
	<T> MutableEntity embed(String rel, T target, EntityConverter<T> converter);
	
	/**
	 * Add a collection of {@link Entity}
	 * converted from the supplied {@link Iterable}
	 * using the {@link EntityConverter} 
	 * @param rel {@link String} name of the related {@link Entity}
	 * @param target {@link Iterable} to convert
	 * @param converter {@link EntityConverter} to use
	 * @return the current {@link EntityBuilder}
	 */
	<T> MutableEntity forEach(String rel, Iterable<T> target, EntityConverter<T> converter);
	
	/**
	 * Add a link with the
	 * supplied name and href
	 * @param link {@link Link} to set
	 * @return
	 */
	MutableEntity link(Link link);
	

}
