package net.eusashead.parquet.entity;

import java.net.URI;

public class Link {
	
	public static final String SELF = "self";
	
	private String rel;
	private URI href;

	public Link(String rel, URI href) {
		this.rel = rel;
		this.href = href;
	}
	
	public String rel() {
		return this.rel;
	}
	
	public URI href() {
		return this.href;
	}
	
	public static Link self(URI href) {
		return new Link(Link.SELF, href);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((href == null) ? 0 : href.hashCode());
		result = prime * result + ((rel == null) ? 0 : rel.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Link other = (Link) obj;
		if (href == null) {
			if (other.href != null)
				return false;
		} else if (!href.equals(other.href))
			return false;
		if (rel == null) {
			if (other.rel != null)
				return false;
		} else if (!rel.equals(other.rel))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("Link [rel=").append(rel).append(", href=").append(href)
				.append("]");
		return builder.toString();
	}

}
