package net.eusashead.parquet.entity;

import java.net.URI;

public interface EntityFactory {
	
	/** 
	 * Clone the supplied {@link Entity}
	 * into a new {@link EntityBuilder} to
	 * enable modifications
	 * @param entity {@link Entity} to clone
	 * @return {@link EntityBuilder} to build {@link Entity}
	 */
	EntityBuilder clone(Entity entity);
	
	/** 
	 * Create an {@link EntityBuilder}
	 * to build an {@link Entity} with 
	 * a self link of {@link URI}
	 * @param uri {@link URI} self link for {@link Entity}
	 * @return {@link EntityBuilder} to build {@link Entity}
	 */
	EntityBuilder newEntity(URI uri);
	
	/**
	 * Create a new {@link EntityBuilder}
	 * with no self {@link URI}
	 * @return {@link EntityBuilder} to build {@link Entity}
	 */
	EntityBuilder newEntity();
	
	/**
	 * Create an {@link Entity} by
	 * converting it using the supplied
	 * {@link EntityConverter} 
	 * @param target {@link Object} to convert
	 * @param converter {@link EntityConverter} to convert with
	 * @return {@link EntityBuilder} result of conversion
	 */
	<T> EntityBuilder convert(T target, EntityConverter<T> converter);

}
