package net.eusashead.parquet.entity;

public interface EntityConverter<T> {
	
	/**
	 * Convert an {@link Object} to
	 * an {@link EntityBuilder} to
	 * create an {@link Entity}
	 * @param target {@link Object} to convert
	 * @param factory {@link EntityFactory} to create the {@link EntityBuilder}
	 * @return converted {@link EntityBuilder}
	 */
	EntityBuilder convert(T target, EntityFactory factory);
	
}
