package net.eusashead.parquet.entity;


public interface EntityBuilder extends MutableEntity {
	
	@Override
	EntityBuilder property(String name, Object value);
	
	@Override
	EntityBuilder property(String name, Object value, PropertyConverter<?,Object> converter);
	
	@Override
	EntityBuilder embed(String rel, Entity entity);
	
	@Override
	<T> EntityBuilder embed(String rel, T target, EntityConverter<T> converter);
	
	@Override
	<T> EntityBuilder forEach(String rel, Iterable<T> target, EntityConverter<T> converter);
	
	@Override
	EntityBuilder link(Link link);
	
	EntityBuilder append(Entity entity);
	
	<T> EntityBuilder append(T target, EntityConverter<T> converter);
	
	/**
	 * Complete the {@link Entity}
	 * under construction
	 * @return the constructed {@link Entity}
	 */
	Entity build();
	
	/**
	 * Get the {@link EntityFactory}
	 * for this {@link EntityBuilder}
	 * @return {@link EntityFactory} that constructed this {@link EntityBuilder}
	 */
	EntityFactory entityFactory();

	/**
	 * Has the {@link EntityBuilder}
	 * been modified
	 * @return
	 */
	boolean empty();

}
