/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.iot.mqtt.paho;

import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.eusashead.iot.mqtt.paho.BaseMqttActionFactory;
import net.eusashead.iot.mqtt.paho.CompletableEmitterMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttException;

public class UnsubscribeFactory
extends BaseMqttActionFactory {
    private static final Logger LOGGER = Logger.getLogger(UnsubscribeFactory.class.getName());

    public UnsubscribeFactory(IMqttAsyncClient client) {
        super(client);
    }

    public Completable create(String[] topics) {
        return Completable.create(emitter -> {
            try {
                this.client.unsubscribe(topics, null, (IMqttActionListener)new UnsubscribeActionListener(emitter));
            }
            catch (MqttException exception) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                }
                emitter.onError((Throwable)exception);
            }
        });
    }

    static final class UnsubscribeActionListener
    extends CompletableEmitterMqttActionListener {
        public UnsubscribeActionListener(CompletableEmitter emitter) {
            super(emitter);
        }

        public void onSuccess(IMqttToken asyncActionToken) {
            this.emitter.onComplete();
        }
    }
}

