/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.iot.mqtt.paho;

import io.reactivex.FlowableEmitter;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.eusashead.iot.mqtt.SubscribeMessage;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;

class SubscriberMqttMessageListener
implements IMqttMessageListener {
    private static final Logger LOGGER = Logger.getLogger(SubscriberMqttMessageListener.class.getName());
    private final FlowableEmitter<? super SubscribeMessage> observer;

    SubscriberMqttMessageListener(FlowableEmitter<? super SubscribeMessage> emitter) {
        this.observer = Objects.requireNonNull(emitter);
    }

    public void messageArrived(String topic, MqttMessage message) {
        LOGGER.log(Level.FINE, String.format("Message %s received on topic %s", message.getId(), topic));
        this.observer.onNext((Object)SubscribeMessage.create(message.getId(), topic, message.getPayload(), message.getQos(), message.isRetained()));
    }
}

