/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.iot.mqtt.paho;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.eusashead.iot.mqtt.SubscribeMessage;
import net.eusashead.iot.mqtt.paho.BaseMqttActionFactory;
import net.eusashead.iot.mqtt.paho.FlowableEmitterMqttActionListener;
import net.eusashead.iot.mqtt.paho.SubscriberMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttException;

public class SubscribeFactory
extends BaseMqttActionFactory {
    private static final Logger LOGGER = Logger.getLogger(SubscribeActionListener.class.getName());

    public SubscribeFactory(IMqttAsyncClient client) {
        super(client);
    }

    public Flowable<SubscribeMessage> create(String[] topics, int[] qos, BackpressureStrategy backpressureStrategy) {
        Objects.requireNonNull(topics);
        Objects.requireNonNull(qos);
        Objects.requireNonNull(backpressureStrategy);
        return Flowable.create(emitter -> {
            IMqttMessageListener[] listeners = new SubscriberMqttMessageListener[topics.length];
            for (int i = 0; i < topics.length; ++i) {
                listeners[i] = new SubscriberMqttMessageListener((FlowableEmitter<? super SubscribeMessage>)emitter);
            }
            try {
                this.client.subscribe(topics, qos, null, (IMqttActionListener)new SubscribeActionListener((FlowableEmitter<? super SubscribeMessage>)emitter), listeners);
            }
            catch (MqttException exception) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                }
                emitter.onError((Throwable)exception);
            }
        }, (BackpressureStrategy)backpressureStrategy);
    }

    static final class SubscribeActionListener
    extends FlowableEmitterMqttActionListener<SubscribeMessage> {
        public SubscribeActionListener(FlowableEmitter<? super SubscribeMessage> observer) {
            super(observer);
        }

        public void onSuccess(IMqttToken asyncActionToken) {
        }
    }
}

