/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.iot.mqtt.paho;

import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.eusashead.iot.mqtt.MqttMessage;
import net.eusashead.iot.mqtt.PublishToken;
import net.eusashead.iot.mqtt.paho.BaseEmitterMqttActionListener;
import net.eusashead.iot.mqtt.paho.BaseMqttActionFactory;
import net.eusashead.iot.mqtt.paho.OnError;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttException;

public class PublishFactory
extends BaseMqttActionFactory {
    private static final Logger LOGGER = Logger.getLogger(PublishFactory.class.getName());

    public PublishFactory(IMqttAsyncClient client) {
        super(client);
    }

    public Single<PublishToken> create(String topic, MqttMessage msg) {
        return Single.create(emitter -> {
            try {
                this.client.publish(topic, msg.getPayload(), msg.getQos(), msg.isRetained(), null, (IMqttActionListener)new PublishActionListener((SingleEmitter<? super PublishToken>)emitter));
            }
            catch (MqttException exception) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                }
                emitter.onError((Throwable)exception);
            }
        });
    }

    static final class PublishActionListener
    extends BaseEmitterMqttActionListener {
        private final SingleEmitter<? super PublishToken> emitter;

        public PublishActionListener(SingleEmitter<? super PublishToken> emitter) {
            this.emitter = Objects.requireNonNull(emitter);
        }

        @Override
        public OnError getOnError() {
            return new OnError(){

                @Override
                public void onError(Throwable t) {
                    emitter.onError(t);
                }
            };
        }

        public void onSuccess(final IMqttToken mqttToken) {
            PublishToken publishToken = new PublishToken(){

                @Override
                public String getClientId() {
                    return mqttToken.getClient().getClientId();
                }

                @Override
                public String[] getTopics() {
                    return mqttToken.getTopics();
                }

                @Override
                public int getMessageId() {
                    return mqttToken.getMessageId();
                }

                @Override
                public boolean getSessionPresent() {
                    return mqttToken.getSessionPresent();
                }
            };
            this.emitter.onSuccess((Object)publishToken);
        }
    }
}

