/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.iot.mqtt.paho;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.util.Objects;
import net.eusashead.iot.mqtt.ObservableMqttClient;
import net.eusashead.iot.mqtt.ObservableMqttClientBuilder;
import net.eusashead.iot.mqtt.PublishMessage;
import net.eusashead.iot.mqtt.PublishToken;
import net.eusashead.iot.mqtt.SubscribeMessage;
import net.eusashead.iot.mqtt.paho.CloseFactory;
import net.eusashead.iot.mqtt.paho.ConnectFactory;
import net.eusashead.iot.mqtt.paho.DisconnectFactory;
import net.eusashead.iot.mqtt.paho.PublishFactory;
import net.eusashead.iot.mqtt.paho.SubscribeFactory;
import net.eusashead.iot.mqtt.paho.UnsubscribeFactory;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class PahoObservableMqttClient
implements ObservableMqttClient {
    private final IMqttAsyncClient client;
    private final CloseFactory closeFactory;
    private final ConnectFactory connectFactory;
    private final DisconnectFactory disconnectFactory;
    private final PublishFactory publishFactory;
    private final SubscribeFactory subscribeFactory;
    private final UnsubscribeFactory unsubscribeFactory;
    private final BackpressureStrategy backpressureStrategy;

    private PahoObservableMqttClient(Builder builder) {
        this.client = builder.client;
        this.closeFactory = builder.closeFactory;
        this.connectFactory = builder.connectFactory;
        this.disconnectFactory = builder.disconnectFactory;
        this.publishFactory = builder.publishFactory;
        this.subscribeFactory = builder.subscribeFactory;
        this.unsubscribeFactory = builder.unsubscribeFactory;
        this.backpressureStrategy = builder.backpressureStrategy;
    }

    @Override
    public String getClientId() {
        return this.client.getClientId();
    }

    @Override
    public String getBrokerUri() {
        return this.client.getServerURI();
    }

    @Override
    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public Completable close() {
        return this.closeFactory.create();
    }

    @Override
    public Completable connect() {
        return this.connectFactory.create();
    }

    @Override
    public Completable disconnect() {
        return this.disconnectFactory.create();
    }

    @Override
    public Single<PublishToken> publish(String topic, PublishMessage msg) {
        return this.publishFactory.create(topic, msg);
    }

    @Override
    public Flowable<SubscribeMessage> subscribe(String[] topics, int[] qos) {
        return this.subscribeFactory.create(topics, qos, this.backpressureStrategy);
    }

    @Override
    public Flowable<SubscribeMessage> subscribe(String topic, int qos) {
        Objects.requireNonNull(topic);
        Objects.requireNonNull(qos);
        return this.subscribe(new String[]{topic}, new int[]{qos});
    }

    @Override
    public Completable unsubscribe(String[] topics) {
        return this.unsubscribeFactory.create(topics);
    }

    @Override
    public Completable unsubscribe(String topic) {
        Objects.requireNonNull(topic);
        return this.unsubscribe(new String[]{topic});
    }

    public static Builder builder(String brokerUri) throws MqttException {
        return PahoObservableMqttClient.builder(brokerUri, MqttAsyncClient.generateClientId());
    }

    public static Builder builder(String brokerUri, String clientId) throws MqttException {
        return PahoObservableMqttClient.builder(brokerUri, clientId, (MqttClientPersistence)new MemoryPersistence());
    }

    public static Builder builder(String brokerUri, String clientId, MqttClientPersistence persistence) throws MqttException {
        return PahoObservableMqttClient.builder((IMqttAsyncClient)new MqttAsyncClient(brokerUri, clientId, persistence));
    }

    public static Builder builder(IMqttAsyncClient client) {
        return new Builder(client);
    }

    public static class Builder
    implements ObservableMqttClientBuilder {
        private final IMqttAsyncClient client;
        private MqttConnectOptions connectOptions;
        private CloseFactory closeFactory;
        private ConnectFactory connectFactory;
        private DisconnectFactory disconnectFactory;
        private PublishFactory publishFactory;
        private SubscribeFactory subscribeFactory;
        private UnsubscribeFactory unsubscribeFactory;
        private BackpressureStrategy backpressureStrategy;

        public Builder(String brokerUri) throws MqttException {
            this(brokerUri, MqttAsyncClient.generateClientId());
        }

        public Builder(String brokerUri, String clientId) throws MqttException {
            this(brokerUri, clientId, (MqttClientPersistence)new MemoryPersistence());
        }

        public Builder(String brokerUri, String clientId, MqttClientPersistence persistence) throws MqttException {
            this((IMqttAsyncClient)new MqttAsyncClient(brokerUri, clientId, persistence));
        }

        public Builder(IMqttAsyncClient client) {
            this.client = client;
            this.connectOptions = new MqttConnectOptions();
            this.closeFactory = new CloseFactory(client);
            this.connectFactory = new ConnectFactory(this.client, this.connectOptions);
            this.disconnectFactory = new DisconnectFactory(client);
            this.publishFactory = new PublishFactory(client);
            this.subscribeFactory = new SubscribeFactory(client);
            this.unsubscribeFactory = new UnsubscribeFactory(client);
            this.backpressureStrategy = BackpressureStrategy.BUFFER;
        }

        public IMqttAsyncClient getClient() {
            return this.client;
        }

        public MqttConnectOptions getConnectOptions() {
            return this.connectOptions;
        }

        public CloseFactory getCloseFactory() {
            return this.closeFactory;
        }

        public ConnectFactory getConnectFactory() {
            return this.connectFactory;
        }

        public DisconnectFactory getDisconnectFactory() {
            return this.disconnectFactory;
        }

        public PublishFactory getPublishFactory() {
            return this.publishFactory;
        }

        public SubscribeFactory getSubscribeFactory() {
            return this.subscribeFactory;
        }

        public UnsubscribeFactory getUnsubscribeFactory() {
            return this.unsubscribeFactory;
        }

        public BackpressureStrategy getBackpressureStrategy() {
            return this.backpressureStrategy;
        }

        public Builder setMqttCallback(MqttCallback mqttCallback) {
            this.client.setCallback(Objects.requireNonNull(mqttCallback));
            return this;
        }

        public Builder setConnectOptions(MqttConnectOptions connectOptions) {
            this.connectOptions = connectOptions;
            this.connectFactory = new ConnectFactory(this.client, this.connectOptions);
            return this;
        }

        public Builder setCloseFactory(CloseFactory closeFactory) {
            this.closeFactory = Objects.requireNonNull(closeFactory);
            return this;
        }

        public Builder setConnectFactory(ConnectFactory connectFactory) {
            this.connectFactory = Objects.requireNonNull(connectFactory);
            return this;
        }

        public Builder setDisconnectFactory(DisconnectFactory disconnectFactory) {
            this.disconnectFactory = Objects.requireNonNull(disconnectFactory);
            return this;
        }

        public Builder setPublishFactory(PublishFactory publishFactory) {
            this.publishFactory = Objects.requireNonNull(publishFactory);
            return this;
        }

        public Builder setSubscribeFactory(SubscribeFactory subscribeFactory) {
            this.subscribeFactory = Objects.requireNonNull(subscribeFactory);
            return this;
        }

        public Builder setUnsubscribeFactory(UnsubscribeFactory unsubscribeFactory) {
            this.unsubscribeFactory = Objects.requireNonNull(unsubscribeFactory);
            return this;
        }

        public Builder setBackpressureStrategy(BackpressureStrategy backpressureStrategy) {
            this.backpressureStrategy = Objects.requireNonNull(backpressureStrategy);
            return this;
        }

        @Override
        public PahoObservableMqttClient build() {
            return new PahoObservableMqttClient(this);
        }
    }
}

