/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.iot.mqtt.paho;

import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.eusashead.iot.mqtt.paho.BaseMqttActionFactory;
import net.eusashead.iot.mqtt.paho.CompletableEmitterMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;

public class ConnectFactory
extends BaseMqttActionFactory {
    private final MqttConnectOptions options;
    private static final Logger LOGGER = Logger.getLogger(ConnectFactory.class.getName());

    public ConnectFactory(IMqttAsyncClient client, MqttConnectOptions options) {
        super(client);
        this.options = Objects.requireNonNull(options);
    }

    public Completable create() {
        return Completable.create(emitter -> {
            try {
                this.client.connect(this.options, null, (IMqttActionListener)new ConnectActionListener(emitter));
            }
            catch (MqttException exception) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                }
                emitter.onError((Throwable)exception);
            }
        });
    }

    public MqttConnectOptions getOptions() {
        return this.options;
    }

    static final class ConnectActionListener
    extends CompletableEmitterMqttActionListener {
        public ConnectActionListener(CompletableEmitter emitter) {
            super(emitter);
        }

        public void onSuccess(IMqttToken asyncActionToken) {
            this.emitter.onComplete();
        }
    }
}

