/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.iot.mqtt;

import java.util.Arrays;
import java.util.Objects;
import net.eusashead.iot.mqtt.AbstractMqttMessage;
import net.eusashead.iot.mqtt.MqttMessage;

public interface SubscribeMessage
extends MqttMessage {
    public int getId();

    public String getTopic();

    public static SubscribeMessage create(int id, String topic, byte[] payload, int qos, boolean retained) {
        return new SubscribeMessageImpl(id, topic, payload, qos, retained);
    }

    public static class SubscribeMessageImpl
    extends AbstractMqttMessage
    implements SubscribeMessage {
        private final int id;
        private final String topic;

        private SubscribeMessageImpl(int id, String topic, byte[] payload, int qos, boolean retained) {
            super(payload, qos, retained);
            this.id = Objects.requireNonNull(id);
            this.topic = Objects.requireNonNull(topic);
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getTopic() {
            return this.topic;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.id;
            result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SubscribeMessageImpl other = (SubscribeMessageImpl)obj;
            if (this.id != other.id) {
                return false;
            }
            return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
        }

        public String toString() {
            return "SubscribeMessageImpl [id=" + this.id + ", topic=" + this.topic + ", payload=" + Arrays.toString(this.payload) + ", qos=" + this.qos + ", retained=" + this.retained + "]";
        }
    }
}

