/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.iot.mqtt;

import java.util.Arrays;
import java.util.Objects;
import net.eusashead.iot.mqtt.MqttMessage;

abstract class AbstractMqttMessage
implements MqttMessage {
    protected final byte[] payload;
    protected final int qos;
    protected final boolean retained;

    AbstractMqttMessage(byte[] payload, int qos, boolean retained) {
        this.payload = Objects.requireNonNull(payload);
        this.qos = qos;
        this.retained = retained;
    }

    @Override
    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    public int getQos() {
        return this.qos;
    }

    @Override
    public boolean isRetained() {
        return this.retained;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.payload);
        result = 31 * result + this.qos;
        result = 31 * result + (this.retained ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMqttMessage other = (AbstractMqttMessage)obj;
        if (!Arrays.equals(this.payload, other.payload)) {
            return false;
        }
        if (this.qos != other.qos) {
            return false;
        }
        return this.retained == other.retained;
    }
}

