/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.hateoas.hal.response.impl;

import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import net.eusashead.hateoas.hal.adapter.RepresentationWriter;
import net.eusashead.hateoas.hal.response.HalResponseBuilder;
import net.eusashead.hateoas.hal.response.impl.AbstractHalResponseBuilder;
import net.eusashead.hateoas.header.ETagHeaderStrategy;
import org.springframework.http.ResponseEntity;

public class HalResponseBuilderImpl
extends AbstractHalResponseBuilder
implements HalResponseBuilder {
    public HalResponseBuilderImpl(RepresentationFactory representationFactory, HttpServletRequest request) {
        super(representationFactory, request);
    }

    @Override
    public HalResponseBuilderImpl withProperty(String name, Object value) {
        this.assertEntity();
        ((Representation)this.entity).withProperty(name, value);
        return this;
    }

    @Override
    public HalResponseBuilderImpl withRepresentation(String rel, ReadableRepresentation resource) {
        this.assertEntity();
        ((Representation)this.entity).withRepresentation(rel, resource);
        return this;
    }

    @Override
    public HalResponseBuilderImpl withLink(String rel, String href) {
        this.assertEntity();
        ((Representation)this.entity).withLink(rel, href);
        return this;
    }

    @Override
    public HalResponseBuilderImpl withNamespace(String namespace, String href) {
        this.assertEntity();
        ((Representation)this.entity).withNamespace(namespace, href);
        return this;
    }

    @Override
    public HalResponseBuilderImpl withBean(Object value) {
        this.assertEntity();
        ((Representation)this.entity).withBean(value);
        return this;
    }

    @Override
    public HalResponseBuilderImpl withBeanBasedRepresentation(String rel, String href, Object o) {
        this.assertEntity();
        ((Representation)this.entity).withBeanBasedRepresentation(rel, href, o);
        return this;
    }

    @Override
    public HalResponseBuilderImpl representation(Representation representation) {
        super.setEntity((Object)representation);
        return this;
    }

    @Override
    public HalResponseBuilderImpl convert(Object bean) {
        this.assertEntity();
        ((Representation)this.entity).withBean(bean);
        return this;
    }

    @Override
    public <T> HalResponseBuilderImpl convert(T bean, RepresentationWriter<T> writer) {
        this.entity = writer.write(bean, this.representationFactory);
        return this;
    }

    @Override
    public HalResponseBuilderImpl etag() {
        super.setEtagHeader();
        return this;
    }

    @Override
    public HalResponseBuilderImpl etag(ETagHeaderStrategy strategy) {
        super.setEtagHeader(strategy);
        return this;
    }

    @Override
    public HalResponseBuilderImpl etag(Date date) {
        super.setEtagHeader(date);
        return this;
    }

    @Override
    public HalResponseBuilderImpl etag(Integer version) {
        super.setEtagHeader(version);
        return this;
    }

    @Override
    public HalResponseBuilderImpl etag(Long version) {
        super.setEtagHeader(version);
        return this;
    }

    @Override
    public HalResponseBuilderImpl lastModified(Date date) {
        super.setLastModifiedHeader(date);
        return this;
    }

    @Override
    public HalResponseBuilderImpl expireIn(long millis) {
        super.setExpiryHeaders(millis);
        return this;
    }

    public ResponseEntity<Representation> build() {
        super.assertEntity();
        return super.buildResponseEntity((Object)((Representation)this.entity));
    }
}

